<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ElevatorModel extends Model
{
    use HasFactory;

    /**
     * الخصائص التي يمكن تعيينها بشكل جماعي.
     *
     * @var array
     */
    protected $fillable = [
        'company_id',
        'type_id',
        'name',
        'code',
        'manufacturer',
        'max_weight',
        'max_persons',
        'speed',
        'specifications',
        'description',
        'is_active',
    ];

    /**
     * الخصائص التي يجب تحويلها.
     *
     * @var array
     */
    protected $casts = [
        'max_weight' => 'integer',
        'max_persons' => 'integer',
        'speed' => 'integer',
        'is_active' => 'boolean',
    ];

    /**
     * الحصول على الشركة المرتبطة بموديل المصعد.
     */
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * الحصول على نوع المصعد المرتبط بهذا الموديل.
     */
    public function type(): BelongsTo
    {
        return $this->belongsTo(ElevatorType::class, 'type_id');
    }

    /**
     * الحصول على المصاعد المرتبطة بهذا الموديل.
     */
    public function elevators(): HasMany
    {
        return $this->hasMany(Elevator::class, 'model_id');
    }
}
