<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ElevatorMaintenanceSchedule extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'elevator_id',
        'maintenance_type',
        'description',
        'frequency', // daily, weekly, monthly, quarterly, semi_annual, annual
        'day_of_week', // 0-6 (Sunday-Saturday)
        'day_of_month', // 1-31
        'month_of_year', // 1-12
        'start_date',
        'end_date',
        'last_run_date',
        'next_run_date',
        'technician_id',
        'estimated_duration',
        'status', // active, inactive, completed
        'created_by',
        'notes',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'last_run_date' => 'date',
        'next_run_date' => 'date',
    ];

    /**
     * Get the elevator that owns the maintenance schedule.
     */
    public function elevator()
    {
        return $this->belongsTo(Elevator::class);
    }

    /**
     * Get the technician that is assigned to the maintenance schedule.
     */
    public function technician()
    {
        return $this->belongsTo(User::class, 'technician_id');
    }

    /**
     * Get the user that created the maintenance schedule.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the company that owns the maintenance schedule.
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * Get the maintenance operations generated from this schedule.
     */
    public function maintenanceOperations()
    {
        return $this->hasMany(ElevatorMaintenance::class, 'schedule_id');
    }
}
