<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ElevatorInventoryRequestItem
 * 
 * @property int $id
 * @property int $elevator_inventory_request_id
 * @property int $inventory_item_id
 * @property int $warehouse_id
 * @property float $quantity
 * @property float $fulfilled_quantity
 * @property string $status
 * @property string|null $notes
 * @property string|null $rejection_reason
 * @property string $priority
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 *
 * @package App\Models
 */
class ElevatorInventoryRequestItem extends Model
{
    use SoftDeletes;
    protected $table = 'elevator_inventory_request_items';

    protected $casts = [
        'elevator_inventory_request_id' => 'int',
        'inventory_item_id' => 'int',
        'warehouse_id' => 'int',
        'quantity' => 'float',
        'fulfilled_quantity' => 'float'
    ];

    protected $fillable = [
        'elevator_inventory_request_id',
        'inventory_item_id',
        'warehouse_id',
        'quantity',
        'fulfilled_quantity',
        'status',
        'notes',
        'rejection_reason',
        'priority'
    ];

    public function request()
    {
        return $this->belongsTo(ElevatorInventoryRequest::class, 'elevator_inventory_request_id');
    }

    public function item()
    {
        return $this->belongsTo(InventoryItem::class, 'inventory_item_id');
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
}
