<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ElevatorInventoryRequest
 * 
 * @property int $id
 * @property int $company_id
 * @property string $request_number
 * @property string $status
 * @property int $requested_by
 * @property int|null $approved_by
 * @property Carbon $requested_date
 * @property Carbon $required_date
 * @property Carbon|null $approval_date
 * @property Carbon|null $fulfillment_date
 * @property string|null $notes
 * @property string|null $rejection_reason
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property User $user
 * @property Company $company
 *
 * @package App\Models
 */
class ElevatorInventoryRequest extends Model
{
    use SoftDeletes;
    protected $table = 'elevator_inventory_requests';

    protected $casts = [
        'company_id' => 'int',
        'requested_by' => 'int',
        'approved_by' => 'int',
        'requested_date' => 'datetime',
        'required_date' => 'datetime',
        'approval_date' => 'datetime',
        'fulfillment_date' => 'datetime'
    ];

    protected $fillable = [
        'company_id',
        'request_number',
        'status',
        'requested_by',
        'approved_by',
        'requested_date',
        'required_date',
        'approval_date',
        'fulfillment_date',
        'notes',
        'rejection_reason'
    ];

    public function requester()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function items()
    {
        return $this->hasMany(ElevatorInventoryRequestItem::class);
    }
}
