<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ElevatorInspection extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'elevator_id',
        'technician_id',
        'inspection_date',
        'inspection_type',
        'status',
        'notes',
        'findings',
        'recommendations',
        'passed',
        'certificate_number',
        'certificate_expiry_date',
    ];

    protected $casts = [
        'inspection_date' => 'date',
        'certificate_expiry_date' => 'date',
        'passed' => 'boolean',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع المصعد
     */
    public function elevator()
    {
        return $this->belongsTo(Elevator::class);
    }

    /**
     * العلاقة مع الفني
     */
    public function technician()
    {
        return $this->belongsTo(User::class, 'technician_id');
    }

    /**
     * الحصول على اسم نوع الفحص بالعربية
     */
    public function getInspectionTypeName()
    {
        $types = [
            'routine' => 'فحص روتيني',
            'safety' => 'فحص سلامة',
            'certification' => 'فحص شهادة',
            'complaint' => 'فحص شكوى',
            'other' => 'فحص آخر',
        ];

        return $types[$this->inspection_type] ?? $this->inspection_type;
    }

    /**
     * الحصول على اسم حالة الفحص بالعربية
     */
    public function getStatusName()
    {
        $statuses = [
            'scheduled' => 'مجدول',
            'in_progress' => 'قيد التنفيذ',
            'completed' => 'مكتمل',
            'cancelled' => 'ملغي',
        ];

        return $statuses[$this->status] ?? $this->status;
    }
}
