<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ElevatorDelivery
 * 
 * @property int $id
 * @property int $company_id
 * @property int $elevator_id
 * @property int $user_id
 * @property Carbon $delivery_date
 * @property Carbon $warranty_end_date
 * @property Carbon $free_maintenance_end_date
 * @property Carbon $control_warranty_end_date
 * @property Carbon $machine_warranty_end_date
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property Elevator $elevator
 * @property User $user
 *
 * @package App\Models
 */
class ElevatorDelivery extends Model
{
    use SoftDeletes;
    protected $table = 'elevator_deliveries';

    protected $casts = [
        'company_id' => 'int',
        'elevator_id' => 'int',
        'user_id' => 'int',
        'delivery_date' => 'datetime',
        'warranty_end_date' => 'datetime',
        'free_maintenance_end_date' => 'datetime',
        'control_warranty_end_date' => 'datetime',
        'machine_warranty_end_date' => 'datetime'
    ];

    protected $fillable = [
        'company_id',
        'elevator_id',
        'user_id',
        'delivery_date',
        'warranty_end_date',
        'free_maintenance_end_date',
        'control_warranty_end_date',
        'machine_warranty_end_date',
        'notes'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function elevator()
    {
        return $this->belongsTo(Elevator::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
