<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Department
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $branch_id
 * @property string $name
 * @property string|null $name_en
 * @property string|null $code
 * @property int|null $manager_id
 * @property int|null $parent_id
 * @property string|null $description
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Branch|null $branch
 * @property Company $company
 * @property Department|null $department
 * @property Collection|Department[] $departments
 * @property Collection|JobTitle[] $job_titles
 *
 * @package App\Models
 */
class Department extends Model
{
	use SoftDeletes;
	protected $table = 'departments';

	protected $casts = [
		'company_id' => 'int',
		'branch_id' => 'int',
		'manager_id' => 'int',
		'parent_id' => 'int',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'branch_id',
		'name',
		'name_en',
		'code',
		'manager_id',
		'parent_id',
		'description',
		'status',
		'created_by',
		'updated_by'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function department()
	{
		return $this->belongsTo(Department::class, 'parent_id');
	}

	public function parent()
	{
		return $this->belongsTo(Department::class, 'parent_id');
	}

	public function departments()
	{
		return $this->hasMany(Department::class, 'parent_id');
	}

	public function children()
	{
		return $this->hasMany(Department::class, 'parent_id');
	}

	public function job_titles()
	{
		return $this->hasMany(JobTitle::class);
	}

	public function manager()
	{
		return $this->belongsTo(Employee::class, 'manager_id');
	}

	public function employees()
	{
		return $this->hasMany(Employee::class);
	}
}
