<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CustomerSurvey
 * 
 * @property int $id
 * @property int $company_id
 * @property int $user_id
 * @property string $title
 * @property string|null $description
 * @property Carbon $start_date
 * @property Carbon|null $end_date
 * @property string $status
 * @property string|null $questions
 * @property int $total_responses
 * @property float $average_rating
 * @property string|null $notes
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User $user
 * @property Collection|SurveyResponse[] $survey_responses
 *
 * @package App\Models
 */
class CustomerSurvey extends Model
{
	use SoftDeletes;
	protected $table = 'customer_surveys';

	protected $casts = [
		'company_id' => 'int',
		'user_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'total_responses' => 'int',
		'average_rating' => 'float'
	];

	protected $fillable = [
		'company_id',
		'user_id',
		'title',
		'description',
		'start_date',
		'end_date',
		'status',
		'questions',
		'total_responses',
		'average_rating',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function survey_responses()
	{
		return $this->hasMany(SurveyResponse::class, 'survey_id');
	}
}
