<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CustomerReward
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string|null $description
 * @property string $type
 * @property int $points_required
 * @property float|null $discount_amount
 * @property int|null $discount_percentage
 * @property Carbon $start_date
 * @property Carbon|null $end_date
 * @property string $status
 * @property int|null $usage_limit
 * @property int $usage_count
 * @property string|null $terms_conditions
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Collection|RewardRedemption[] $reward_redemptions
 *
 * @package App\Models
 */
class CustomerReward extends Model
{
	use SoftDeletes;
	protected $table = 'customer_rewards';

	protected $casts = [
		'company_id' => 'int',
		'points_required' => 'int',
		'discount_amount' => 'float',
		'discount_percentage' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'usage_limit' => 'int',
		'usage_count' => 'int'
	];

	protected $fillable = [
		'company_id',
		'name',
		'description',
		'type',
		'points_required',
		'discount_amount',
		'discount_percentage',
		'start_date',
		'end_date',
		'status',
		'usage_limit',
		'usage_count',
		'terms_conditions'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function reward_redemptions()
	{
		return $this->hasMany(RewardRedemption::class, 'reward_id');
	}
}
