<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CustomerInteraction
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int $user_id
 * @property string $type
 * @property string $title
 * @property string|null $description
 * @property Carbon $interaction_date
 * @property Carbon|null $follow_up_date
 * @property string $status
 * @property string $outcome
 * @property string|null $notes
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Customer $customer
 * @property User $user
 * @property \Illuminate\Database\Eloquent\Collection|InteractionFollowUp[] $followUps
 *
 * @package App\Models
 */
class CustomerInteraction extends Model
{
	use SoftDeletes;
	protected $table = 'customer_interactions';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'user_id' => 'int',
		'interaction_date' => 'datetime',
		'follow_up_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'user_id',
		'type',
		'title',
		'description',
		'interaction_date',
		'follow_up_date',
		'status',
		'outcome',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	/**
	 * العلاقة مع متابعات التفاعل
	 */
	public function followUps()
	{
		return $this->hasMany(InteractionFollowUp::class, 'interaction_id');
	}
}
