<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Customer
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $branch_id
 * @property int|null $user_id
 * @property string $name
 * @property string|null $contact_person
 * @property string|null $contact_phone
 * @property string|null $contact_position
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $mobile
 * @property string|null $address
 * @property string|null $city
 * @property string|null $state
 * @property string|null $country
 * @property string|null $postal_code
 * @property string|null $tax_number
 * @property string|null $notes
 * @property string $type
 * @property string $status
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property User|null $user
 * @property Collection|CampaignMember[] $campaign_members
 * @property Collection|CustomerInteraction[] $customer_interactions
 * @property Collection|CustomerStatement[] $customer_statements
 * @property Collection|Elevator[] $elevators
 * @property Collection|InstallationProject[] $installation_projects
 * @property Collection|Invoice[] $invoices
 * @property Collection|Location[] $locations
 * @property Collection|LoyaltyPoint[] $loyalty_points
 * @property Collection|MaintenanceContract[] $maintenance_contracts
 * @property Collection|Opportunity[] $opportunities
 * @property Collection|RewardRedemption[] $reward_redemptions
 * @property Collection|SurveyResponse[] $survey_responses
 *
 * @package App\Models
 */
class Customer extends Model
{
	use SoftDeletes;
	protected $table = 'customers';

	protected $casts = [
		'company_id' => 'int',
		'branch_id' => 'int',
		'user_id' => 'int',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'branch_id',
		'user_id',
		'name',
		'contact_person',
		'contact_phone',
		'contact_position',
		'email',
		'phone',
		'mobile',
		'address',
		'city',
		'state',
		'country',
		'postal_code',
		'tax_number',
		'notes',
		'type',
		'status',
		'is_active'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function campaign_members()
	{
		return $this->hasMany(CampaignMember::class);
	}

	public function customer_interactions()
	{
		return $this->hasMany(CustomerInteraction::class);
	}

	public function customer_statements()
	{
		return $this->hasMany(CustomerStatement::class);
	}

	public function elevators()
	{
		return $this->hasMany(Elevator::class);
	}

	public function installation_projects()
	{
		return $this->hasMany(InstallationProject::class);
	}

	public function invoices()
	{
		return $this->hasMany(Invoice::class);
	}

	public function locations()
	{
		return $this->hasMany(Location::class);
	}

	public function loyalty_points()
	{
		return $this->hasMany(LoyaltyPoint::class);
	}

	public function maintenance_contracts()
	{
		return $this->hasMany(MaintenanceContract::class);
	}

	public function opportunities()
	{
		return $this->hasMany(Opportunity::class);
	}

	public function reward_redemptions()
	{
		return $this->hasMany(RewardRedemption::class);
	}

	public function survey_responses()
	{
		return $this->hasMany(SurveyResponse::class);
	}
}
