<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ContractElevator
 * 
 * @property int $id
 * @property int $maintenance_contract_id
 * @property int $elevator_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Elevator $elevator
 * @property MaintenanceContract $maintenance_contract
 *
 * @package App\Models
 */
class ContractElevator extends Model
{
	protected $table = 'contract_elevator';

	protected $casts = [
		'maintenance_contract_id' => 'int',
		'elevator_id' => 'int'
	];

	protected $fillable = [
		'maintenance_contract_id',
		'elevator_id'
	];

	public function elevator()
	{
		return $this->belongsTo(Elevator::class);
	}

	public function maintenance_contract()
	{
		return $this->belongsTo(MaintenanceContract::class);
	}
}
