<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Company
 * 
 * @property int $id
 * @property string $name
 * @property string|null $name_en
 * @property string $slug
 * @property string|null $domain
 * @property string $database_prefix
 * @property string|null $cr_number
 * @property string|null $vat_number
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $mobile
 * @property string|null $website
 * @property string|null $address
 * @property string|null $address_en
 * @property string|null $city
 * @property string|null $state
 * @property string|null $postal_code
 * @property string|null $tax_number
 * @property string $country
 * @property string|null $logo
 * @property string $currency
 * @property float $tax_rate
 * @property float $vat_rate
 * @property bool $is_active
 * @property string $subscription_plan
 * @property Carbon|null $subscription_ends_at
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Collection|AutoPurchaseRule[] $auto_purchase_rules
 * @property Collection|BarcodeTemplate[] $barcode_templates
 * @property Collection|Branch[] $branches
 * @property Collection|CampaignMember[] $campaign_members
 * @property Collection|CustomerInteraction[] $customer_interactions
 * @property Collection|CustomerReward[] $customer_rewards
 * @property Collection|CustomerStatement[] $customer_statements
 * @property Collection|CustomerSurvey[] $customer_surveys
 * @property Collection|Customer[] $customers
 * @property Collection|Department[] $departments
 * @property Collection|Elevator[] $elevators
 * @property Collection|Employee[] $employees
 * @property Collection|FinancialReport[] $financial_reports
 * @property Collection|InstallationProject[] $installation_projects
 * @property Collection|InventoryBatch[] $inventory_batches
 * @property Collection|InventoryCategory[] $inventory_categories
 * @property Collection|InventoryItem[] $inventory_items
 * @property Collection|InventorySerial[] $inventory_serials
 * @property Collection|InventoryStock[] $inventory_stocks
 * @property Collection|InventoryTransaction[] $inventory_transactions
 * @property Collection|InventoryValuation[] $inventory_valuations
 * @property Collection|InvoiceTemplate[] $invoice_templates
 * @property Collection|Invoice[] $invoices
 * @property Collection|JobTitle[] $job_titles
 * @property Collection|Location[] $locations
 * @property Collection|LoyaltyPoint[] $loyalty_points
 * @property Collection|MaintenanceContract[] $maintenance_contracts
 * @property Collection|MaintenanceLog[] $maintenance_logs
 * @property Collection|MaintenanceSchedule[] $maintenance_schedules
 * @property Collection|MarketingCampaign[] $marketing_campaigns
 * @property Collection|Notification[] $notifications
 * @property Collection|Opportunity[] $opportunities
 * @property Collection|PaymentMethod[] $payment_methods
 * @property Collection|Payment[] $payments
 * @property Collection|PayrollItem[] $payroll_items
 * @property Collection|Payroll[] $payrolls
 * @property Collection|ProjectInventoryRequest[] $project_inventory_requests
 * @property Collection|PurchaseOrder[] $purchase_orders
 * @property Collection|RewardRedemption[] $reward_redemptions
 * @property Collection|Role[] $roles
 * @property Collection|Salary[] $salaries
 * @property Collection|SalaryComponent[] $salary_components
 * @property Collection|SalaryPolicy[] $salary_policies
 * @property Collection|SupplierEvaluation[] $supplier_evaluations
 * @property Collection|Supplier[] $suppliers
 * @property Collection|SurveyResponse[] $survey_responses
 * @property Collection|TaxBracket[] $tax_brackets
 * @property Collection|TaxReport[] $tax_reports
 * @property Collection|TaxSetting[] $tax_settings
 * @property Collection|User[] $users
 * @property Collection|Warehouse[] $warehouses
 *
 * @package App\Models
 */
class Company extends Model
{
	use SoftDeletes;
	protected $table = 'companies';

	protected $casts = [
		'tax_rate' => 'float',
		'vat_rate' => 'float',
		'is_active' => 'bool',
		'subscription_ends_at' => 'datetime'
	];

	protected $fillable = [
		'name',
		'name_en',
		'slug',
		'domain',
		'database_prefix',
		'cr_number',
		'vat_number',
		'email',
		'phone',
		'mobile',
		'website',
		'address',
		'address_en',
		'city',
		'state',
		'postal_code',
		'tax_number',
		'country',
		'logo',
		'currency',
		'tax_rate',
		'vat_rate',
		'is_active',
		'subscription_plan',
		'subscription_ends_at',
		'notes',
		'created_by',
		'primary_user_id'
	];

	public function auto_purchase_rules()
	{
		return $this->hasMany(AutoPurchaseRule::class);
	}

	public function barcode_templates()
	{
		return $this->hasMany(BarcodeTemplate::class);
	}

	public function branches()
	{
		return $this->hasMany(Branch::class);
	}

	public function campaign_members()
	{
		return $this->hasMany(CampaignMember::class);
	}

	public function customer_interactions()
	{
		return $this->hasMany(CustomerInteraction::class);
	}

	public function customer_rewards()
	{
		return $this->hasMany(CustomerReward::class);
	}

	public function customer_statements()
	{
		return $this->hasMany(CustomerStatement::class);
	}

	public function customer_surveys()
	{
		return $this->hasMany(CustomerSurvey::class);
	}

	public function customers()
	{
		return $this->hasMany(Customer::class);
	}

	public function departments()
	{
		return $this->hasMany(Department::class);
	}

	public function elevators()
	{
		return $this->hasMany(Elevator::class);
	}

	public function employees()
	{
		return $this->hasMany(Employee::class);
	}

	public function financial_reports()
	{
		return $this->hasMany(FinancialReport::class);
	}

	public function installation_projects()
	{
		return $this->hasMany(InstallationProject::class);
	}

	public function inventory_batches()
	{
		return $this->hasMany(InventoryBatch::class);
	}

	public function inventory_categories()
	{
		return $this->hasMany(InventoryCategory::class);
	}

	public function inventory_items()
	{
		return $this->hasMany(InventoryItem::class);
	}

	public function inventory_serials()
	{
		return $this->hasMany(InventorySerial::class);
	}

	public function inventory_stocks()
	{
		return $this->hasMany(InventoryStock::class);
	}

	public function inventory_transactions()
	{
		return $this->hasMany(InventoryTransaction::class);
	}

	public function inventory_valuations()
	{
		return $this->hasMany(InventoryValuation::class);
	}

	public function invoice_templates()
	{
		return $this->hasMany(InvoiceTemplate::class);
	}

	public function invoices()
	{
		return $this->hasMany(Invoice::class);
	}

	public function job_titles()
	{
		return $this->hasMany(JobTitle::class);
	}

	public function locations()
	{
		return $this->hasMany(Location::class);
	}

	public function loyalty_points()
	{
		return $this->hasMany(LoyaltyPoint::class);
	}

	public function maintenance_contracts()
	{
		return $this->hasMany(MaintenanceContract::class);
	}

	public function maintenance_logs()
	{
		return $this->hasMany(MaintenanceLog::class);
	}

	public function maintenance_schedules()
	{
		return $this->hasMany(MaintenanceSchedule::class);
	}

	public function marketing_campaigns()
	{
		return $this->hasMany(MarketingCampaign::class);
	}

	public function notifications()
	{
		return $this->hasMany(Notification::class);
	}

	public function opportunities()
	{
		return $this->hasMany(Opportunity::class);
	}

	public function payment_methods()
	{
		return $this->hasMany(PaymentMethod::class);
	}

	public function payments()
	{
		return $this->hasMany(Payment::class);
	}

	public function payroll_items()
	{
		return $this->hasMany(PayrollItem::class);
	}

	public function payrolls()
	{
		return $this->hasMany(Payroll::class);
	}

	public function project_inventory_requests()
	{
		return $this->hasMany(ProjectInventoryRequest::class);
	}

	public function purchase_orders()
	{
		return $this->hasMany(PurchaseOrder::class);
	}

	public function reward_redemptions()
	{
		return $this->hasMany(RewardRedemption::class);
	}

	public function roles()
	{
		return $this->hasMany(Role::class);
	}

	public function salaries()
	{
		return $this->hasMany(Salary::class);
	}

	public function salary_components()
	{
		return $this->hasMany(SalaryComponent::class);
	}

	public function salary_policies()
	{
		return $this->hasMany(SalaryPolicy::class);
	}

	public function supplier_evaluations()
	{
		return $this->hasMany(SupplierEvaluation::class);
	}

	public function suppliers()
	{
		return $this->hasMany(Supplier::class);
	}

	public function survey_responses()
	{
		return $this->hasMany(SurveyResponse::class);
	}

	public function tax_brackets()
	{
		return $this->hasMany(TaxBracket::class);
	}

	public function tax_reports()
	{
		return $this->hasMany(TaxReport::class);
	}

	public function tax_settings()
	{
		return $this->hasMany(TaxSetting::class);
	}

	public function users()
	{
		return $this->hasMany(User::class);
	}

	public function warehouses()
	{
		return $this->hasMany(Warehouse::class);
	}

	public function settings()
	{
		return $this->hasOne(CompanySetting::class);
	}

	/**
	 * Get the user who created this company
	 */
	public function creator()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	/**
	 * Get the primary user for this company
	 */
	public function primaryUser()
	{
		return $this->belongsTo(User::class, 'primary_user_id');
	}
}
