<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CivilDefenseTerminationLetter extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_id',
        'elevator_id',
        'customer_id',
        'customer_address',
        'termination_date',
        'created_by',
    ];

    protected $dates = [
        'termination_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * Get the elevator associated with the termination letter.
     */
    public function elevator()
    {
        return $this->belongsTo(Elevator::class);
    }

    /**
     * Get the customer associated with the termination letter.
     */
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    /**
     * Get the company associated with the termination letter.
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * Get the user who created the termination letter.
     */
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
