<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CampaignMember
 * 
 * @property int $id
 * @property int $company_id
 * @property int $campaign_id
 * @property int $customer_id
 * @property string $status
 * @property Carbon|null $sent_at
 * @property Carbon|null $opened_at
 * @property Carbon|null $clicked_at
 * @property Carbon|null $responded_at
 * @property Carbon|null $converted_at
 * @property string|null $response_details
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property MarketingCampaign $marketing_campaign
 * @property Company $company
 * @property Customer $customer
 *
 * @package App\Models
 */
class CampaignMember extends Model
{
	use SoftDeletes;
	protected $table = 'campaign_members';

	protected $casts = [
		'company_id' => 'int',
		'campaign_id' => 'int',
		'customer_id' => 'int',
		'sent_at' => 'datetime',
		'opened_at' => 'datetime',
		'clicked_at' => 'datetime',
		'responded_at' => 'datetime',
		'converted_at' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'campaign_id',
		'customer_id',
		'status',
		'sent_at',
		'opened_at',
		'clicked_at',
		'responded_at',
		'converted_at',
		'response_details'
	];

	public function marketing_campaign()
	{
		return $this->belongsTo(MarketingCampaign::class, 'campaign_id');
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}
}
