<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Branch
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string|null $name_en
 * @property string|null $code
 * @property string|null $manager_name
 * @property string|null $phone
 * @property string|null $mobile
 * @property string|null $email
 * @property string|null $address
 * @property string|null $address_en
 * @property string|null $city
 * @property string|null $state
 * @property string|null $country
 * @property string|null $postal_code
 * @property float|null $location_lat
 * @property float|null $location_lng
 * @property bool|null $is_main_branch
 * @property bool $is_active
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property Collection|CustomerStatement[] $customer_statements
 * @property Collection|Department[] $departments
 * @property Collection|Elevator[] $elevators
 * @property Collection|Employee[] $employees
 * @property Collection|FinancialReport[] $financial_reports
 * @property Collection|InstallationProject[] $installation_projects
 * @property Collection|Invoice[] $invoices
 * @property Collection|MaintenanceContract[] $maintenance_contracts
 * @property Collection|User[] $users
 * @property Collection|Warehouse[] $warehouses
 *
 * @package App\Models
 */
class Branch extends Model
{
	use SoftDeletes;
	protected $table = 'branches';

	protected $casts = [
		'company_id' => 'int',
		'location_lat' => 'float',
		'location_lng' => 'float',
		'is_main_branch' => 'bool',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'name_en',
		'code',
		'manager_name',
		'phone',
		'mobile',
		'email',
		'address',
		'address_en',
		'city',
		'state',
		'country',
		'postal_code',
		'location_lat',
		'location_lng',
		'is_main_branch',
		'is_active',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer_statements()
	{
		return $this->hasMany(CustomerStatement::class);
	}

	public function departments()
	{
		return $this->hasMany(Department::class);
	}

	public function elevators()
	{
		return $this->hasMany(Elevator::class);
	}

	public function employees()
	{
		return $this->hasMany(Employee::class);
	}

	public function financial_reports()
	{
		return $this->hasMany(FinancialReport::class);
	}

	public function installation_projects()
	{
		return $this->hasMany(InstallationProject::class);
	}

	public function invoices()
	{
		return $this->hasMany(Invoice::class);
	}

	public function maintenance_contracts()
	{
		return $this->hasMany(MaintenanceContract::class);
	}

	public function users()
	{
		return $this->hasMany(User::class);
	}

	public function warehouses()
	{
		return $this->hasMany(Warehouse::class);
	}
}
