<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class BarcodeTemplate
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property float $width
 * @property float $height
 * @property string|null $settings
 * @property int $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property User|null $user
 *
 * @package App\Models
 */
class BarcodeTemplate extends Model
{
	use SoftDeletes;
	protected $table = 'barcode_templates';

	protected $casts = [
		'company_id' => 'int',
		'width' => 'float',
		'height' => 'float',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'name',
		'width',
		'height',
		'settings',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'updated_by');
	}
}
