<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankReconciliationItem extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'bank_reconciliation_id',
        'bank_transaction_id',
        'cheque_id',
        'item_type',
        'status',
        'amount',
        'transaction_date',
        'description',
        'is_system_record',
        'is_statement_record',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'amount' => 'decimal:2',
        'transaction_date' => 'date',
        'is_system_record' => 'boolean',
        'is_statement_record' => 'boolean',
    ];

    /**
     * Get the bank reconciliation that owns the bank reconciliation item.
     */
    public function bankReconciliation()
    {
        return $this->belongsTo(BankReconciliation::class);
    }

    /**
     * Get the bank transaction associated with the bank reconciliation item.
     */
    public function bankTransaction()
    {
        return $this->belongsTo(BankTransaction::class);
    }

    /**
     * Get the cheque associated with the bank reconciliation item.
     */
    public function cheque()
    {
        return $this->belongsTo(Cheque::class);
    }
}
