<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankReconciliation extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'company_id',
        'bank_account_id',
        'reconciliation_number',
        'statement_date',
        'reconciliation_date',
        'statement_balance',
        'system_balance',
        'difference',
        'notes',
        'status',
        'created_by',
        'approved_by',
        'approved_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'statement_date' => 'date',
        'reconciliation_date' => 'date',
        'statement_balance' => 'decimal:2',
        'system_balance' => 'decimal:2',
        'difference' => 'decimal:2',
        'approved_at' => 'datetime',
    ];

    /**
     * Get the company that owns the bank reconciliation.
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * Get the bank account that owns the bank reconciliation.
     */
    public function bankAccount()
    {
        return $this->belongsTo(BankAccount::class);
    }

    /**
     * Get the user who created the bank reconciliation.
     */
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the user who approved the bank reconciliation.
     */
    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    /**
     * Get the bank reconciliation items for the bank reconciliation.
     */
    public function bankReconciliationItems()
    {
        return $this->hasMany(BankReconciliationItem::class);
    }
}
