<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class AutoPurchaseRule
 * 
 * @property int $id
 * @property int $company_id
 * @property int $item_id
 * @property int $supplier_id
 * @property int $warehouse_id
 * @property float $min_quantity
 * @property float $order_quantity
 * @property bool $is_active
 * @property Carbon|null $last_triggered_at
 * @property int $frequency_days
 * @property Carbon|null $next_check_date
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property InventoryItem $inventory_item
 * @property Supplier $supplier
 * @property Warehouse $warehouse
 * @property Collection|PurchaseOrder[] $purchase_orders
 *
 * @package App\Models
 */
class AutoPurchaseRule extends Model
{
	protected $table = 'auto_purchase_rules';

	protected $casts = [
		'company_id' => 'int',
		'item_id' => 'int',
		'supplier_id' => 'int',
		'warehouse_id' => 'int',
		'min_quantity' => 'float',
		'order_quantity' => 'float',
		'is_active' => 'bool',
		'last_triggered_at' => 'datetime',
		'frequency_days' => 'int',
		'next_check_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'item_id',
		'supplier_id',
		'warehouse_id',
		'min_quantity',
		'order_quantity',
		'is_active',
		'last_triggered_at',
		'frequency_days',
		'next_check_date'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function supplier()
	{
		return $this->belongsTo(Supplier::class);
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}

	public function purchase_orders()
	{
		return $this->hasMany(PurchaseOrder::class);
	}
}
