<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ActivityLog
 * 
 * @property int $id
 * @property int|null $user_id
 * @property string $action
 * @property string $description
 * @property string $level
 * @property string|null $ip_address
 * @property string|null $user_agent
 * @property string|null $subject_type
 * @property int|null $subject_id
 * @property string|null $properties
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $old_values
 * @property string|null $new_values
 * @property string|null $url
 * @property string|null $method
 * 
 * @property User|null $user
 *
 * @package App\Models
 */
class ActivityLog extends Model
{
	protected $table = 'activity_logs';

	protected $casts = [
		'user_id' => 'int',
		'subject_id' => 'int',
		'old_values' => 'json',
		'new_values' => 'json',
		'properties' => 'json'
	];

	protected $fillable = [
		'user_id',
		'action',
		'description',
		'level',
		'ip_address',
		'user_agent',
		'subject_type',
		'subject_id',
		'properties',
		'old_values',
		'new_values',
		'url',
		'method'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
