<?php

namespace App\Mail;

use App\Models\Notification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MaintenanceNotificationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * الإشعار المراد إرساله.
     *
     * @var \App\Models\Notification
     */
    public $notification;

    /**
     * إنشاء مثيل جديد للرسالة.
     *
     * @param  \App\Models\Notification  $notification
     * @return void
     */
    public function __construct(Notification $notification)
    {
        $this->notification = $notification;
    }

    /**
     * بناء الرسالة.
     *
     * @return $this
     */
    /**
     * Get notification data as an array
     *
     * @return array
     */
    protected function getNotificationData()
    {
        $data = $this->notification->data;

        // Ensure data is an array
        if (!is_array($data)) {
            $data = json_decode($data, true);
        }

        return is_array($data) ? $data : [];
    }

    /**
     * بناء الرسالة.
     *
     * @return $this
     */
    public function build()
    {
        $subject = '';

        // تحديد عنوان الرسالة بناءً على نوع الإشعار
        switch ($this->notification->type) {
            case 'maintenance_due':
                $subject = 'تذكير: صيانة مصعد مستحقة قريباً';
                break;
            case 'maintenance_overdue':
                $subject = 'تنبيه: صيانة مصعد متأخرة';
                break;
            case 'contract_expiring':
                $subject = 'تنبيه: عقد صيانة على وشك الانتهاء';
                break;
            case 'maintenance_completed':
                $subject = 'تم إكمال صيانة المصعد بنجاح';
                break;
            case 'maintenance_issue':
                $subject = 'تنبيه: مشكلة في صيانة المصعد';
                break;
            default:
                $subject = 'إشعار من نظام إدارة المصاعد';
        }

        return $this->subject($subject)
            ->markdown('emails.maintenance.notification')
            ->with([
                'title' => $this->notification->title,
                'message' => $this->notification->message,
                'data' => $this->getNotificationData(),
                'actionUrl' => isset($this->getNotificationData()['action_url'])
                    ? $this->getNotificationData()['action_url']
                    : route('dashboard'),
                'actionText' => isset($this->getNotificationData()['action_text'])
                    ? $this->getNotificationData()['action_text']
                    : 'عرض التفاصيل',
            ]);
    }
}
