<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

class RunScheduler
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // تشغيل المهام المجدولة فقط مرة واحدة كل 5 دقائق لتجنب التحميل الزائد
        $lastRun = cache('scheduler_last_run');
        $now = now();

        if (!$lastRun || $now->diffInMinutes($lastRun) >= 5) {
            try {
                // تسجيل بدء تشغيل المهام المجدولة
                Log::info('تشغيل المهام المجدولة تلقائياً');

                // تشغيل المهام المجدولة مع تسجيل نتائج كل مهمة على حدة
                Log::info('تشغيل فحص جداول الصيانة');
                Artisan::call('maintenance:check-schedules');
                Log::info('نتائج فحص جداول الصيانة: ' . trim(Artisan::output()));

                Log::info('تشغيل فحص الصيانة اليومية');
                Artisan::call('maintenance:check-daily');
                Log::info('نتائج فحص الصيانة اليومية: ' . trim(Artisan::output()));

                Log::info('تشغيل فحص الصيانة المتأخرة');
                Artisan::call('maintenance:check-overdue');
                Log::info('نتائج فحص الصيانة المتأخرة: ' . trim(Artisan::output()));

                Log::info('تشغيل إرسال الإشعارات المعلقة');
                Artisan::call('notifications:send-pending');
                Log::info('نتائج إرسال الإشعارات المعلقة: ' . trim(Artisan::output()));

                // تسجيل اكتمال تشغيل المهام المجدولة
                Log::info('اكتمل تشغيل المهام المجدولة تلقائياً');

                // تحديث وقت آخر تشغيل
                cache(['scheduler_last_run' => $now], 60 * 60); // تخزين لمدة ساعة
            } catch (\Exception $e) {
                Log::error('خطأ في تشغيل المهام المجدولة: ' . $e->getMessage());
            }
        }

        return $next($request);
    }
}
