<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CompanyMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // التحقق من أن المستخدم مسجل الدخول
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        // التحقق من أن المستخدم لديه شركة مرتبطة
        $user = Auth::user();
        
        // السماح لمديري النظام بالمرور دون شركة مرتبطة
        if (!$user->company_id && !$user->isSystemAdmin()) {
            return redirect()->route('dashboard')->with('error', 'ليس لديك شركة مرتبطة بحسابك');
        }

        // تعيين company_id في الجلسة
        $request->session()->put('company_id', $user->company_id);

        return $next($request);
    }
}
