<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Active
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // تحقق مما إذا كان المستخدم نشطًا
        if (Auth::check() && Auth::user()->is_active) {
            return $next($request);
        }

        // إذا لم يكن المستخدم نشطًا، قم بتسجيل الخروج وإعادة التوجيه
        Auth::logout();
        return redirect()->route('login')->with('error', 'حسابك غير نشط. يرجى الاتصال بالمسؤول.');
    }
}
