<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class TempCheckController extends Controller
{
    public function checkUserPermissions($username)
    {
        $user = User::where('username', $username)->first();

        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }

        $permissions = $user->getAllPermissions()->pluck('slug')->toArray();
        $roles = $user->roles->pluck('name')->toArray();

        $hasCustomerInteractionPermissions = [
            'view_customer_interaction' => in_array('view_customer_interaction', $permissions),
            'create_customer_interaction' => in_array('create_customer_interaction', $permissions),
            'edit_customer_interaction' => in_array('edit_customer_interaction', $permissions),
            'delete_customer_interaction' => in_array('delete_customer_interaction', $permissions),
            'manage_customer_interactions' => in_array('manage_customer_interactions', $permissions),
        ];

        $hasCustomerRewardPermissions = [
            'view_customer_reward' => in_array('view_customer_reward', $permissions),
            'create_customer_reward' => in_array('create_customer_reward', $permissions),
            'edit_customer_reward' => in_array('edit_customer_reward', $permissions),
            'delete_customer_reward' => in_array('delete_customer_reward', $permissions),
        ];

        return response()->json([
            'user_id' => $user->id,
            'username' => $user->username,
            'roles' => $roles,
            'all_permissions' => $permissions,
            'customer_interaction_permissions' => $hasCustomerInteractionPermissions,
            'customer_reward_permissions' => $hasCustomerRewardPermissions,
            'should_see_menu' => (
                $hasCustomerInteractionPermissions['view_customer_interaction'] ||
                $hasCustomerInteractionPermissions['create_customer_interaction'] ||
                $hasCustomerInteractionPermissions['manage_customer_interactions'] ||
                $hasCustomerRewardPermissions['view_customer_reward'] ||
                $hasCustomerRewardPermissions['create_customer_reward'] ||
                $hasCustomerRewardPermissions['edit_customer_reward'] ||
                $hasCustomerRewardPermissions['delete_customer_reward']
            )
        ]);
    }
}
