<?php

namespace App\Http\Controllers\Inventory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;

class AutoPurchaseRunController extends Controller
{
    /**
     * تشغيل فحص الشراء التلقائي يدوياً.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function runCheck(Request $request)
    {
        // التحقق من الصلاحيات
        if (!Auth::user()->can('run_auto_purchase_check')) {
            return redirect()->route('inventory.auto-purchase.index')->with('error', 'ليس لديك صلاحية لتشغيل فحص الشراء التلقائي');
        }

        // تشغيل الأمر المجدول
        $companyId = Auth::user()->company_id;
        $userId = Auth::id();

        $exitCode = Artisan::call('inventory:auto-purchase-check', [
            '--company' => $companyId,
            '--user' => $userId
        ]);

        $output = Artisan::output();

        // استخراج عدد طلبات الشراء التي تم إنشاؤها من النتيجة
        preg_match('/تم إنشاء (\d+) طلب شراء/', $output, $matches);
        $count = $matches[1] ?? 0;

        if ($exitCode === 0) {
            return redirect()->route('inventory.auto-purchase.index')
                ->with('success', "تم تشغيل فحص الشراء التلقائي بنجاح. تم إنشاء {$count} طلب شراء.");
        } else {
            return redirect()->route('inventory.auto-purchase.index')
                ->with('error', 'حدث خطأ أثناء تشغيل فحص الشراء التلقائي.');
        }
    }
}
