<?php

namespace App\Http\Controllers;

use App\Models\Elevator;
use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ElevatorWarrantyReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * عرض تقرير انتهاء ضمان المصاعد
     */
    public function index(Request $request)
    {
        $companyId = Auth::user()->company_id;

        $query = Elevator::where('elevators.company_id', $companyId)
            ->join('customers', 'elevators.customer_id', '=', 'customers.id')
            ->select(
                'elevators.id',
                'elevators.serial_number',
                'customers.name as customer_name',
                'customers.id as customer_id',
                'elevators.free_maintenance_end_date',
                'elevators.warranty_end_date',
                'elevators.control_warranty_end_date',
                'elevators.machine_warranty_end_date',
                'elevators.status'
            );

        // تصفية حسب العميل
        if ($request->has('customer_id') && $request->customer_id != '') {
            $query->where('customers.id', $request->customer_id);
        }

        // تصفية حسب اسم العميل
        if ($request->has('customer_name') && $request->customer_name != '') {
            $query->where('customers.name', 'like', '%' . $request->customer_name . '%');
        }

        // تصفية حسب تاريخ انتهاء الضمان
        if ($request->has('from_date') && $request->from_date != '') {
            $query->where(function ($q) use ($request) {
                $q->whereDate('elevators.warranty_end_date', '>=', $request->from_date)
                    ->orWhereDate('elevators.free_maintenance_end_date', '>=', $request->from_date)
                    ->orWhereDate('elevators.control_warranty_end_date', '>=', $request->from_date)
                    ->orWhereDate('elevators.machine_warranty_end_date', '>=', $request->from_date);
            });
        }

        if ($request->has('to_date') && $request->to_date != '') {
            $query->where(function ($q) use ($request) {
                $q->whereDate('elevators.warranty_end_date', '<=', $request->to_date)
                    ->orWhereDate('elevators.free_maintenance_end_date', '<=', $request->to_date)
                    ->orWhereDate('elevators.control_warranty_end_date', '<=', $request->to_date)
                    ->orWhereDate('elevators.machine_warranty_end_date', '<=', $request->to_date);
            });
        }

        // الحصول على قائمة العملاء للفلتر
        $customers = Customer::where('company_id', $companyId)
            ->select('id', 'name')
            ->orderBy('name')
            ->get();

        $elevators = $query->orderBy('elevators.id')->get();

        return view('elevator-reports.warranty-report', compact('elevators', 'customers'));
    }
}
