<?php

namespace App\Http\Controllers;

use App\Models\ElevatorStage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ElevatorStageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $companyId = Auth::user()->company_id;
        $stages = ElevatorStage::where('company_id', $companyId)
            ->orderBy('order')
            ->paginate(10);

        return view('elevator_stages.index', compact('stages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('elevator_stages.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'percentage' => 'required|numeric|min:0|max:100',
            'order' => 'required|integer|min:1',
        ]);

        $data = $request->all();
        $data['company_id'] = Auth::user()->company_id;

        ElevatorStage::create($data);

        return redirect()->route('elevator-stages.index')
            ->with('success', 'تم إضافة مرحلة المصعد بنجاح');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $companyId = Auth::user()->company_id;
        $stage = ElevatorStage::where('company_id', $companyId)
            ->findOrFail($id);

        return view('elevator_stages.show', compact('stage'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $companyId = Auth::user()->company_id;
        $stage = ElevatorStage::where('company_id', $companyId)
            ->findOrFail($id);

        return view('elevator_stages.edit', compact('stage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'percentage' => 'required|numeric|min:0|max:100',
            'order' => 'required|integer|min:1',
        ]);

        $companyId = Auth::user()->company_id;
        $stage = ElevatorStage::where('company_id', $companyId)
            ->findOrFail($id);

        $stage->update($request->all());

        return redirect()->route('elevator-stages.index')
            ->with('success', 'تم تحديث مرحلة المصعد بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $companyId = Auth::user()->company_id;
        $stage = ElevatorStage::where('company_id', $companyId)
            ->findOrFail($id);

        $stage->delete();

        return redirect()->route('elevator-stages.index')
            ->with('success', 'تم حذف مرحلة المصعد بنجاح');
    }
}
