<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UpdateDemoUserRolesController extends Controller
{
    /**
     * تحديث صلاحيات المستخدم التجريبي
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function updateDemoUserRoles()
    {
        try {
            // البحث عن المستخدم التجريبي
            $demoUser = User::where('email', 'demo@elevators.com')->first();

            if (!$demoUser) {
                return redirect()->back()->with('error', 'لم يتم العثور على المستخدم التجريبي');
            }

            // الحصول على جميع الأدوار المتاحة في النظام
            $allRoles = Role::all();

            // حذف جميع الأدوار الحالية للمستخدم التجريبي
            DB::table('role_user')->where('user_id', $demoUser->id)->delete();

            // إضافة جميع الأدوار للمستخدم التجريبي
            $roleData = [];
            $now = now();

            foreach ($allRoles as $role) {
                $roleData[] = [
                    'role_id' => $role->id,
                    'user_id' => $demoUser->id,
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
            }

            DB::table('role_user')->insert($roleData);

            return redirect()->back()->with('success', 'تم تحديث صلاحيات المستخدم التجريبي بنجاح. الآن يمتلك المستخدم التجريبي جميع الأدوار والصلاحيات في النظام.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث صلاحيات المستخدم التجريبي: ' . $e->getMessage());
        }
    }
}
