<?php

namespace App\Http\Controllers;

use App\Models\InstallationProject;
use App\Models\ProjectPhase;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AllProjectPhasesController extends Controller
{
    /**
     * عرض قائمة جميع مراحل المشاريع
     */
    public function index()
    {
        // التحقق من الصلاحيات
        if (!Auth::user()->hasPermission('view_installation_projects')) {
            return redirect()->route('dashboard')->with('error', 'ليس لديك صلاحية للوصول إلى هذه الصفحة');
        }

        // الحصول على جميع المشاريع التي ينتمي إليها المستخدم
        $projects = InstallationProject::where('company_id', Auth::user()->company_id)
            ->orderBy('created_at', 'desc')
            ->get();

        // الحصول على جميع مراحل المشاريع
        $phases = ProjectPhase::whereIn('installation_project_id', $projects->pluck('id'))
            ->with('installationProject') // تحميل علاقة المشروع
            ->orderBy('created_at', 'desc')
            ->paginate(15);

        return view('installation-projects.phases.all', compact('phases'));
    }
}
