<?php

namespace App\Exports;

use App\Models\Payroll;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PayrollExport implements FromCollection, WithHeadings, WithMapping, WithTitle, ShouldAutoSize, WithStyles
{
    protected $payroll;

    public function __construct(Payroll $payroll)
    {
        $this->payroll = $payroll;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->payroll->payrollItems()->with('employee')->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            '#',
            'اسم الموظف',
            'الرقم الوظيفي',
            'القسم',
            'المسمى الوظيفي',
            'الراتب الأساسي',
            'إجمالي البدلات',
            'إجمالي الخصومات',
            'صافي الراتب',
            'أيام العمل',
            'أيام الإجازة',
            'أيام الغياب',
            'ساعات العمل الإضافي',
            'مبلغ العمل الإضافي',
            'دقائق التأخير',
            'خصم التأخير',
        ];
    }

    /**
     * @param mixed $row
     * @return array
     */
    public function map($payrollItem): array
    {
        static $i = 0;
        $i++;

        return [
            $i,
            $payrollItem->employee->name,
            $payrollItem->employee->employee_id,
            $payrollItem->employee->department->name ?? 'غير محدد',
            $payrollItem->employee->designation->name ?? 'غير محدد',
            $payrollItem->basic_salary,
            $payrollItem->total_allowances,
            $payrollItem->total_deductions,
            $payrollItem->net_salary,
            $payrollItem->working_days,
            $payrollItem->leave_days,
            $payrollItem->absent_days,
            $payrollItem->overtime_hours,
            $payrollItem->overtime_amount,
            $payrollItem->late_minutes,
            $payrollItem->late_deduction,
        ];
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'كشف الرواتب - ' . $this->payroll->payroll_period;
    }

    /**
     * @param Worksheet $sheet
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text
            1 => ['font' => ['bold' => true]],
        ];
    }
}
