<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;

class LocationsTemplateExport implements FromArray, WithHeadings, WithTitle
{
    /**
     * @return array
     */
    public function array(): array
    {
        return [
            [
                '1', // customer_id
                'شركة الاختبار', // customer_name
                'الموقع الرئيسي', // name
                '1', // branch_id
                'شارع الملك فهد', // address
                'الرياض', // city
                'الرياض', // state
                'السعودية', // country
                '12345', // postal_code
                'أحمد محمد', // contact_person
                '0500000000', // contact_phone
                'ahmed@example.com', // contact_email
                'office', // location_type
                '24.7136', // latitude
                '46.6753', // longitude
                'ملاحظات تجريبية', // notes
                '1', // company_id (optional for admin)
            ]
        ];
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'customer_id',
            'customer_name',
            'name',
            'branch_id',
            'address',
            'city',
            'state',
            'country',
            'postal_code',
            'contact_person',
            'contact_phone',
            'contact_email',
            'location_type',
            'latitude',
            'longitude',
            'notes',
            'company_id',
        ];
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'Locations Import Template';
    }
}
