<?php

namespace App\Exports;

use App\Models\Customer;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;

class CustomersExport implements FromCollection, WithHeadings, WithMapping
{
    protected $query;

    public function __construct($query = null)
    {
        $this->query = $query;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $user = Auth::user();
        $company_id = $user->company_id;

        if ($this->query) {
            return $this->query->get();
        }

        return Customer::where('company_id', $company_id)->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'الاسم',
            'جهة الاتصال',
            'هاتف جهة الاتصال',
            'منصب جهة الاتصال',
            'البريد الإلكتروني',
            'الهاتف',
            'الجوال',
            'العنوان',
            'المدينة',
            'المنطقة',
            'البلد',
            'الرمز البريدي',
            'الرقم الضريبي',
            'ملاحظات',
            'النوع',
            'الحالة',
            'معرف الفرع',
            'معرف المستخدم',
        ];
    }

    /**
     * @param Customer $customer
     * @return array
     */
    public function map($customer): array
    {
        return [
            $customer->id,
            $customer->name,
            $customer->contact_person,
            $customer->contact_phone,
            $customer->contact_position,
            $customer->email,
            $customer->phone,
            $customer->mobile,
            $customer->address,
            $customer->city,
            $customer->state,
            $customer->country,
            $customer->postal_code,
            $customer->tax_number,
            $customer->notes,
            $customer->type,
            $customer->status,
            $customer->branch_id,
            $customer->user_id,
        ];
    }
}
