<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();

        // التحقق من جدولة الصيانة المستقبلية يومياً في الساعة 8:00 صباحاً
        $schedule->command('maintenance:check-schedules')->dailyAt('08:00');

        // التحقق من الصيانة المستحقة اليوم في الساعة 7:00 صباحاً
        $schedule->command('maintenance:check-daily')->dailyAt('07:00');

        // التحقق من الصيانة المستحقة اليوم مرة أخرى في الساعة 12:00 ظهراً (للتذكير)
        $schedule->command('maintenance:check-daily')->dailyAt('12:00');

        // إنشاء الفواتير التلقائية من العقود في اليوم الأول من كل شهر
        $schedule->command('invoices:generate --type=contracts')->monthlyOn(1, '09:00');

        // إنشاء الفواتير التلقائية من جدولة الصيانة كل يوم أحد
        $schedule->command('invoices:generate --type=maintenance')->weekly()->sundays()->at('10:00');

        // التحقق من قواعد الشراء التلقائي يومياً في الساعة 7:00 صباحاً
        $schedule->command('inventory:auto-purchase-check')->dailyAt('07:00');

        // التحقق من الضمانات التي ستنتهي قريباً أسبوعياً يوم الاثنين في الساعة 9:00 صباحاً
        $schedule->command('maintenance:check-warranties')->weekly()->mondays()->at('09:00');

        // إرسال الإشعارات المعلقة كل ساعة
        $schedule->command('notifications:send-pending')->hourly();

        // التحقق من الصيانة المتأخرة يومياً في الساعة 9:00 صباحاً
        $schedule->command('maintenance:check-overdue')->dailyAt('09:00');

        // التحقق من جميع أنواع الصيانة مرة واحدة أسبوعياً يوم الأحد في الساعة 6:00 صباحاً
        $schedule->command('maintenance:check-all')->weekly()->sundays()->at('06:00');

        // التحقق من جميع أنواع الصيانة في بداية كل شهر
        $schedule->command('maintenance:check-all')->monthlyOn(1, '06:30');

        // تحديث حالة الأقساط المتأخرة يومياً في الساعة 00:05 صباحاً
        $schedule->command('installments:update-overdue')->dailyAt('00:05');

        // إرسال تذكيرات الأقساط المستحقة والمتأخرة يومياً في الساعة 09:00 صباحاً
        $schedule->command('installments:send-reminders')->dailyAt('09:00');

        // التحقق من تنبيهات المخزون يومياً في الساعة 06:00 صباحاً
        $schedule->command('inventory:check-alerts')->dailyAt('06:00');

        // التحقق من تذكيرات متابعة العملاء يومياً في الساعة 08:30 صباحاً
        $schedule->command('customers:check-follow-up')->dailyAt('08:30');

        // فحص ميزان المراجعة أسبوعياً يوم السبت في الساعة 23:00 مساءً
        $schedule->command('accounting:check-trial-balance --fix --email=admin@example.com')->weekly()->saturdays()->at('23:00');

        // فحص ميزان المراجعة في نهاية كل شهر
        $schedule->command('accounting:check-trial-balance --fix --email=admin@example.com')->monthlyOn(28, '23:30');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
