<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\PurchaseInvoice;
use App\Models\User;

class UpdatePurchaseInvoicesCompanyId extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'purchase-invoices:update-company-id {--company-id= : معرف الشركة الافتراضي للفواتير التي ليس لها شركة}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث حقل company_id للفواتير القديمة التي ليس لها قيمة';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء تحديث حقل company_id لفواتير المشتريات...');

        // الحصول على عدد الفواتير التي ليس لها company_id
        $nullCompanyIdCount = PurchaseInvoice::whereNull('company_id')->count();
        $this->info("تم العثور على {$nullCompanyIdCount} فاتورة بدون معرف شركة.");

        if ($nullCompanyIdCount === 0) {
            $this->info('لا توجد فواتير تحتاج إلى تحديث.');
            return Command::SUCCESS;
        }

        // الخطوة 1: تحديث الفواتير بناءً على الشركة التي ينتمي إليها المستخدم الذي أنشأها
        $this->info('تحديث الفواتير بناءً على شركة المستخدم الذي أنشأها...');

        $updatedByCreator = DB::table('purchase_invoices as pi')
            ->join('users as u', 'pi.created_by', '=', 'u.id')
            ->whereNull('pi.company_id')
            ->whereNotNull('u.company_id')
            ->update(['pi.company_id' => DB::raw('u.company_id')]);

        $this->info("تم تحديث {$updatedByCreator} فاتورة بناءً على شركة المستخدم الذي أنشأها.");

        // الخطوة 2: تحديث الفواتير المتبقية باستخدام معرف الشركة الافتراضي
        $remainingNullCount = PurchaseInvoice::whereNull('company_id')->count();

        if ($remainingNullCount > 0) {
            $defaultCompanyId = $this->option('company-id') ?: 1;
            $this->info("تحديث {$remainingNullCount} فاتورة متبقية باستخدام معرف الشركة الافتراضي ({$defaultCompanyId})...");

            $updatedWithDefault = PurchaseInvoice::whereNull('company_id')
                ->update(['company_id' => $defaultCompanyId]);

            $this->info("تم تحديث {$updatedWithDefault} فاتورة باستخدام معرف الشركة الافتراضي.");
        }

        // التحقق من النتائج النهائية
        $finalNullCount = PurchaseInvoice::whereNull('company_id')->count();

        if ($finalNullCount === 0) {
            $this->info('تم تحديث جميع الفواتير بنجاح!');
            return Command::SUCCESS;
        } else {
            $this->error("لا يزال هناك {$finalNullCount} فاتورة بدون معرف شركة.");
            return Command::FAILURE;
        }
    }
}
