<?php

namespace App\Console\Commands;

use App\Models\InvoiceInstallment;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class UpdateOverdueInstallments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'installments:update-overdue';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث حالة الأقساط المتأخرة';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء تحديث حالة الأقساط المتأخرة...');

        try {
            DB::beginTransaction();

            // الحصول على الأقساط المتأخرة التي لم يتم تحديثها بعد
            $overdueInstallments = InvoiceInstallment::where('status', 'pending')
                ->where('due_date', '<', Carbon::now()->startOfDay())
                ->where('paid_amount', '<', DB::raw('amount'))
                ->get();

            $count = $overdueInstallments->count();
            $this->info("تم العثور على {$count} قسط متأخر.");

            $bar = $this->output->createProgressBar($count);
            $bar->start();

            foreach ($overdueInstallments as $installment) {
                // تحديث حالة القسط إلى متأخر
                $installment->status = 'overdue';
                $installment->save();

                // تحديث حالة الفاتورة إذا لزم الأمر
                $invoice = $installment->invoice;
                if ($invoice && $invoice->status !== 'overdue' && $invoice->due_amount > 0) {
                    $invoice->status = 'overdue';
                    $invoice->save();
                }

                $bar->advance();
            }

            $bar->finish();
            $this->newLine();

            DB::commit();
            $this->info("تم تحديث {$count} قسط متأخر بنجاح.");

            // تسجيل العملية في السجل
            Log::info("تم تحديث {$count} قسط متأخر بواسطة الأمر المجدول.");

            return 0;
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error('حدث خطأ أثناء تحديث الأقساط المتأخرة: ' . $e->getMessage());
            Log::error('خطأ في تحديث الأقساط المتأخرة: ' . $e->getMessage());

            return 1;
        }
    }
}
