<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\InstallmentPermissionsSeeder;

class UpdateInstallmentPermissions extends Command
{
    /**
     * اسم الأمر وتوصيفه.
     *
     * @var string
     */
    protected $signature = 'permissions:update-installments';

    /**
     * وصف الأمر.
     *
     * @var string
     */
    protected $description = 'تحديث صلاحيات نظام إدارة الأقساط';

    /**
     * تنفيذ الأمر.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('جاري تحديث صلاحيات نظام إدارة الأقساط...');

        // تنفيذ بذر صلاحيات الأقساط
        $seeder = new InstallmentPermissionsSeeder();
        $seeder->run();

        $this->info('تم تحديث صلاحيات نظام إدارة الأقساط بنجاح!');

        return Command::SUCCESS;
    }
}
