<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\HRMPermissionsSeeder;

class UpdateHRMPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hrm:update-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث صلاحيات نظام الموارد البشرية';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('جاري تحديث صلاحيات نظام الموارد البشرية...');

        $seeder = new HRMPermissionsSeeder();
        $seeder->setCommand($this);
        $seeder->run();

        $this->info('تم تحديث صلاحيات نظام الموارد البشرية بنجاح!');

        return 0;
    }
}
