<?php

namespace App\Console\Commands;

use App\Models\Role;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateDemoUserRoles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'demo:update-roles';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث صلاحيات المستخدم التجريبي وإعطائه جميع الأدوار';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            // البحث عن المستخدم التجريبي
            $demoUser = User::where('email', 'demo@elevators.com')->first();

            if (!$demoUser) {
                $this->error('لم يتم العثور على المستخدم التجريبي');
                return 1;
            }

            // الحصول على جميع الأدوار المتاحة في النظام
            $allRoles = Role::all();

            // حذف جميع الأدوار الحالية للمستخدم التجريبي
            DB::table('role_user')->where('user_id', $demoUser->id)->delete();

            // إضافة جميع الأدوار للمستخدم التجريبي
            $roleData = [];
            $now = now();

            foreach ($allRoles as $role) {
                $roleData[] = [
                    'role_id' => $role->id,
                    'user_id' => $demoUser->id,
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
            }

            DB::table('role_user')->insert($roleData);

            $this->info('تم تحديث صلاحيات المستخدم التجريبي بنجاح. الآن يمتلك المستخدم التجريبي جميع الأدوار والصلاحيات في النظام.');
            return 0;
        } catch (\Exception $e) {
            $this->error('حدث خطأ أثناء تحديث صلاحيات المستخدم التجريبي: ' . $e->getMessage());
            return 1;
        }
    }
}
