<?php

namespace App\Console\Commands;

use App\Models\Permission;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateDemoUserPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'demo:update-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تحديث صلاحيات المستخدم التجريبي وإعطائه جميع الصلاحيات المباشرة';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            // البحث عن المستخدم التجريبي
            $demoUser = User::where('email', 'demo@elevators.com')->first();

            if (!$demoUser) {
                $this->error('لم يتم العثور على المستخدم التجريبي');
                return 1;
            }

            // الحصول على جميع الصلاحيات المتاحة في النظام
            $allPermissions = Permission::all();

            // حذف جميع الصلاحيات المباشرة الحالية للمستخدم التجريبي
            DB::table('permission_user')->where('user_id', $demoUser->id)->delete();

            // إضافة جميع الصلاحيات المباشرة للمستخدم التجريبي
            $permissionData = [];
            $now = now();

            foreach ($allPermissions as $permission) {
                $permissionData[] = [
                    'permission_id' => $permission->id,
                    'user_id' => $demoUser->id,
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
            }

            DB::table('permission_user')->insert($permissionData);

            // إضافة صلاحيات خاصة للوصول إلى صفحات الأدوار والصلاحيات
            $specialPermissions = [
                'manage_roles',
                'manage_permissions',
                'view_roles',
                'create_roles',
                'edit_roles',
                'delete_roles',
                'view_permissions',
                'create_permissions',
                'edit_permissions',
                'delete_permissions',
                'view_users',
                'create_users',
                'edit_users',
                'delete_users',
                'assign_roles',
                'assign_permissions'
            ];

            // التأكد من وجود هذه الصلاحيات وإضافتها إذا لم تكن موجودة
            foreach ($specialPermissions as $permName) {
                $permission = Permission::where('name', $permName)->first();

                if (!$permission) {
                    $permission = Permission::create([
                        'name' => $permName,
                        'slug' => $permName,
                        'description' => 'صلاحية ' . $permName,
                        'is_active' => 1,
                        'created_at' => $now,
                        'updated_at' => $now,
                    ]);

                    // إضافة الصلاحية الجديدة للمستخدم التجريبي
                    DB::table('permission_user')->insert([
                        'permission_id' => $permission->id,
                        'user_id' => $demoUser->id,
                        'created_at' => $now,
                        'updated_at' => $now,
                    ]);
                }
            }

            $this->info('تم تحديث صلاحيات المستخدم التجريبي بنجاح. الآن يمتلك المستخدم التجريبي جميع الصلاحيات المباشرة في النظام.');
            return 0;
        } catch (\Exception $e) {
            $this->error('حدث خطأ أثناء تحديث صلاحيات المستخدم التجريبي: ' . $e->getMessage());
            return 1;
        }
    }
}
