<?php

namespace App\Console\Commands;

use App\Models\CashRegister;
use App\Services\CashRegisterService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class UpdateCashRegisterAccounts extends Command
{
    /**
     * اسم الأمر وتوصيفه
     *
     * @var string
     */
    protected $signature = 'cash-registers:update-accounts';

    /**
     * وصف الأمر
     *
     * @var string
     */
    protected $description = 'تحديث حسابات الخزائن في شجرة الحسابات';

    /**
     * خدمة إدارة الخزائن
     *
     * @var CashRegisterService
     */
    protected $cashRegisterService;

    /**
     * إنشاء مثيل جديد من الأمر
     *
     * @param CashRegisterService $cashRegisterService
     * @return void
     */
    public function __construct(CashRegisterService $cashRegisterService)
    {
        parent::__construct();
        $this->cashRegisterService = $cashRegisterService;
    }

    /**
     * تنفيذ الأمر
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء تحديث حسابات الخزائن في شجرة الحسابات...');

        $cashRegisters = CashRegister::all();
        $count = 0;
        $errors = 0;

        foreach ($cashRegisters as $cashRegister) {
            try {
                $this->cashRegisterService->createOrUpdateCashRegisterAccount($cashRegister);
                $this->info("تم تحديث حساب الخزينة: {$cashRegister->name}");
                $count++;
            } catch (\Exception $e) {
                $this->error("خطأ في تحديث حساب الخزينة {$cashRegister->name}: {$e->getMessage()}");
                Log::error("خطأ في تحديث حساب الخزينة {$cashRegister->name}: {$e->getMessage()}");
                $errors++;
            }
        }

        $this->info("اكتمل التحديث. تم تحديث {$count} خزينة بنجاح. {$errors} خزينة فشل تحديثها.");

        return 0;
    }
}
