<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class SeedNotificationPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'permissions:seed-notifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed notification permissions and assign them to roles';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Seeding notification permissions...');

        try {
            Artisan::call('db:seed', [
                '--class' => 'Database\\Seeders\\NotificationPermissionsSeeder',
                '--force' => true
            ]);

            $this->info('Notification permissions seeded successfully!');
            return 0;
        } catch (\Exception $e) {
            $this->error('Error seeding notification permissions: ' . $e->getMessage());
            return 1;
        }
    }
}
