<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\MaintenancePermissionsSeeder;

class SeedMaintenancePermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'permissions:seed-maintenance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed maintenance system permissions to the database';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Seeding maintenance permissions...');

        $seeder = new MaintenancePermissionsSeeder();
        $seeder->run();

        $this->info('Maintenance permissions seeded successfully!');

        return 0;
    }
}
