<?php

namespace App\Console\Commands;

use Database\Seeders\CashRegisterPermissionsSeeder;
use Illuminate\Console\Command;

class SeedCashRegisterPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:cash-register-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed cash register permissions to the database';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Seeding cash register permissions...');

        $seeder = new CashRegisterPermissionsSeeder();
        $seeder->run();

        $this->info('Cash register permissions seeded successfully!');

        return Command::SUCCESS;
    }
}
