<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Permission;

class ListPermissionGroups extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'list:permission-groups';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'List all permission groups and their permissions';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $permissions = Permission::orderBy('group')
            ->orderBy('name')
            ->get();

        $groups = $permissions->groupBy('group');

        $this->info('Found ' . $groups->count() . ' permission groups:');

        foreach ($groups as $group => $groupPermissions) {
            $this->line("\n<bg=blue;fg=white> GROUP: " . ($group ?: 'General') . " </>");
            $this->table(
                ['ID', 'Name', 'Slug', 'Description'],
                $groupPermissions->map(function ($permission) {
                    return [
                        'ID' => $permission->id,
                        'Name' => $permission->name,
                        'Slug' => $permission->slug,
                        'Description' => $permission->description ?: '-'
                    ];
                })
            );
        }

        return Command::SUCCESS;
    }
}
