<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

class FixUserPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'permissions:fix {username} {permission}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إضافة صلاحية محددة لمستخدم معين';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $username = $this->argument('username');
        $permissionSlug = $this->argument('permission');

        // البحث عن المستخدم
        $user = User::where('name', $username)->first();

        if (!$user) {
            $this->error("المستخدم '{$username}' غير موجود!");
            return 1;
        }

        // البحث عن الصلاحية
        $permission = Permission::where('slug', $permissionSlug)->first();

        if (!$permission) {
            $this->error("الصلاحية '{$permissionSlug}' غير موجودة!");
            return 1;
        }

        // التحقق مما إذا كان المستخدم يملك الصلاحية بالفعل
        if ($user->hasPermission($permissionSlug)) {
            $this->info("المستخدم '{$username}' يملك بالفعل صلاحية '{$permissionSlug}'");
            return 0;
        }

        // إضافة الصلاحية للمستخدم
        DB::table('user_permission')->insert([
            'user_id' => $user->id,
            'permission_id' => $permission->id,
            'granted' => true,
            'source' => 'manual_fix',
            'created_at' => now(),
            'updated_at' => now()
        ]);

        $this->info("تمت إضافة صلاحية '{$permissionSlug}' للمستخدم '{$username}' بنجاح!");

        return 0;
    }
}
