<?php

namespace App\Console\Commands;

use App\Models\User;
use App\Models\Permission;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class FixSidebarPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sidebar:fix {email}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إصلاح مشكلة عدم ظهور الصلاحيات في القائمة الجانبية';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $email = $this->argument('email');

        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error("المستخدم غير موجود: {$email}");
            return Command::FAILURE;
        }

        // حذف الصلاحيات الحالية
        DB::table('user_permission')->where('user_id', $user->id)->delete();

        // إضافة جميع الصلاحيات بشكل مباشر
        $permissions = Permission::all();
        $count = 0;

        foreach ($permissions as $permission) {
            DB::table('user_permission')->insert([
                'user_id' => $user->id,
                'permission_id' => $permission->id,
                'granted' => true,
                'source' => 'direct',
                'created_at' => now(),
                'updated_at' => now()
            ]);
            $count++;
        }

        // مسح ذاكرة التخزين المؤقت للمستخدم
        Cache::forget('user_permissions_' . $user->id);

        // إضافة صلاحيات خاصة بالقائمة الجانبية
        $sidebarPermissions = [
            'view_dashboard',
            'manage_users',
            'manage_roles',
            'manage_permissions',
            'manage_companies',
            'manage_branches',
            'manage_customers',
            'manage_suppliers',
            'manage_inventory',
            'manage_warehouses',
            'manage_maintenance',
            'manage_projects',
            'manage_invoices',
            'manage_reports',
            'manage_settings',
            'view_urgent_notifications',
            'manage_notification_settings',
            'view_notification_logs',
            'manage_hrm',
            'manage_employees',
            'manage_attendance',
            'manage_payroll',
            'manage_leave',
            'manage_departments',
            'manage_positions',
            'manage_contracts',
            'manage_documents',
            'manage_tasks',
            'manage_calendar',
            'manage_chat',
            'manage_email',
            'manage_sms',
            'manage_backup',
            'manage_logs',
            'manage_system',
            'manage_api',
            'manage_integrations',
            'manage_translations',
            'manage_themes',
            'manage_plugins',
            'manage_updates',
            'manage_security',
            'manage_audit',
            'manage_activity',
            'manage_notifications',
            'manage_dashboard',
            'manage_profile',
            'manage_account',
            'manage_preferences',
            'manage_subscription',
            'manage_billing',
            'manage_payment',
            'manage_invoice',
            'manage_tax',
            'manage_discount',
            'manage_coupon',
            'manage_promotion',
            'manage_marketing',
            'manage_campaign',
            'manage_newsletter',
            'manage_social',
            'manage_analytics',
            'manage_reports',
            'manage_statistics',
            'manage_charts',
            'manage_graphs',
            'manage_exports',
            'manage_imports',
            'manage_backups',
            'manage_restore',
            'manage_cleanup',
            'manage_optimize',
            'manage_cache',
            'manage_queue',
            'manage_schedule',
            'manage_cron',
            'manage_jobs',
            'manage_workers',
            'manage_supervisor',
            'manage_monitor',
            'manage_health',
            'manage_status',
            'manage_logs',
            'manage_errors',
            'manage_exceptions',
            'manage_debug',
            'manage_trace',
            'manage_profile',
            'manage_performance',
            'manage_optimization',
            'manage_speed',
            'manage_cache',
            'manage_cdn',
            'manage_assets',
            'manage_resources',
            'manage_files',
            'manage_uploads',
            'manage_downloads',
            'manage_media',
            'manage_images',
            'manage_videos',
            'manage_audio',
            'manage_documents',
            'manage_attachments',
            'manage_gallery',
            'manage_library',
            'manage_repository',
            'manage_storage',
            'manage_cloud',
            'manage_s3',
            'manage_dropbox',
            'manage_google',
            'manage_onedrive',
            'manage_box',
            'manage_ftp',
            'manage_sftp',
            'manage_ssh',
            'manage_shell',
            'manage_terminal',
            'manage_console',
            'manage_command',
            'manage_script',
            'manage_batch',
            'manage_automation',
            'manage_workflow',
            'manage_process',
            'manage_pipeline',
            'manage_integration',
            'manage_api',
            'manage_webhook',
            'manage_callback',
            'manage_event',
            'manage_listener',
            'manage_subscriber',
            'manage_publisher',
            'manage_queue',
            'manage_bus',
            'manage_channel',
            'manage_broadcast',
            'manage_socket',
            'manage_realtime',
            'manage_live',
            'manage_stream',
            'manage_feed',
            'manage_notification',
            'manage_alert',
            'manage_message',
            'manage_mail',
            'manage_email',
            'manage_smtp',
            'manage_imap',
            'manage_pop3',
            'manage_mailbox',
            'manage_inbox',
            'manage_outbox',
            'manage_sent',
            'manage_draft',
            'manage_trash',
            'manage_spam',
            'manage_archive',
            'manage_folder',
            'manage_label',
            'manage_tag',
            'manage_category',
            'manage_group',
            'manage_collection',
            'manage_set',
            'manage_list',
            'manage_array',
            'manage_map',
            'manage_dictionary',
            'manage_hash',
            'manage_tree',
            'manage_graph',
            'manage_network',
            'manage_mesh',
            'manage_grid',
            'manage_matrix',
            'manage_table',
            'manage_row',
            'manage_column',
            'manage_cell',
            'manage_header',
            'manage_footer',
            'manage_sidebar',
            'manage_navbar',
            'manage_menu',
            'manage_submenu',
            'manage_dropdown',
            'manage_item',
            'manage_link',
            'manage_button',
            'manage_action',
            'manage_event',
            'manage_trigger',
            'manage_handler',
            'manage_callback',
            'manage_function',
            'manage_method',
            'manage_procedure',
            'manage_routine',
            'manage_program',
            'manage_application',
            'manage_service',
            'manage_daemon',
            'manage_worker',
            'manage_thread',
            'manage_process',
            'manage_task',
            'manage_job',
            'manage_schedule',
            'manage_cron',
            'manage_timer',
            'manage_clock',
            'manage_time',
            'manage_date',
            'manage_calendar',
            'manage_event',
            'manage_appointment',
            'manage_meeting',
            'manage_conference',
            'manage_call',
            'manage_video',
            'manage_audio',
            'manage_chat',
            'manage_message',
            'manage_conversation',
            'manage_discussion',
            'manage_forum',
            'manage_board',
            'manage_post',
            'manage_thread',
            'manage_reply',
            'manage_comment',
            'manage_review',
            'manage_rating',
            'manage_vote',
            'manage_poll',
            'manage_survey',
            'manage_form',
            'manage_input',
            'manage_output',
            'manage_field',
            'manage_validation',
            'manage_verification',
            'manage_authentication',
            'manage_authorization',
            'manage_permission',
            'manage_role',
            'manage_user',
            'manage_account',
            'manage_profile',
            'manage_identity',
            'manage_credential',
            'manage_password',
            'manage_token',
            'manage_session',
            'manage_cookie',
            'manage_cache',
            'manage_storage',
            'manage_memory',
            'manage_disk',
            'manage_file',
            'manage_directory',
            'manage_folder',
            'manage_path',
            'manage_url',
            'manage_uri',
            'manage_link',
            'manage_route',
            'manage_navigation',
            'manage_map',
            'manage_location',
            'manage_position',
            'manage_coordinate',
            'manage_gps',
            'manage_geo',
            'manage_region',
            'manage_zone',
            'manage_area',
            'manage_territory',
            'manage_district',
            'manage_city',
            'manage_state',
            'manage_province',
            'manage_country',
            'manage_continent',
            'manage_world',
            'manage_universe',
            'manage_space',
            'manage_time',
            'manage_dimension',
            'manage_measurement',
            'manage_unit',
            'manage_scale',
            'manage_metric',
            'manage_standard',
            'manage_norm',
            'manage_rule',
            'manage_policy',
            'manage_guideline',
            'manage_procedure',
            'manage_process',
            'manage_workflow',
            'manage_pipeline',
            'manage_stage',
            'manage_phase',
            'manage_step',
            'manage_task',
            'manage_action',
            'manage_operation',
            'manage_function',
            'manage_method',
            'manage_technique',
            'manage_approach',
            'manage_strategy',
            'manage_plan',
            'manage_project',
            'manage_program',
            'manage_portfolio',
            'manage_initiative',
            'manage_mission',
            'manage_vision',
            'manage_goal',
            'manage_objective',
            'manage_target',
            'manage_milestone',
            'manage_deliverable',
            'manage_outcome',
            'manage_output',
            'manage_result',
            'manage_achievement',
            'manage_success',
            'manage_failure',
            'manage_error',
            'manage_exception',
            'manage_issue',
            'manage_problem',
            'manage_incident',
            'manage_ticket',
            'manage_request',
            'manage_order',
            'manage_reservation',
            'manage_booking',
            'manage_appointment',
            'manage_schedule',
            'manage_calendar',
            'manage_event',
            'manage_activity',
            'manage_log',
            'manage_record',
            'manage_entry',
            'manage_item',
            'manage_element',
            'manage_component',
            'manage_module',
            'manage_package',
            'manage_library',
            'manage_framework',
            'manage_platform',
            'manage_system',
            'manage_application',
            'manage_service',
            'manage_api',
            'manage_interface',
            'manage_ui',
            'manage_ux',
            'manage_design',
            'manage_layout',
            'manage_theme',
            'manage_style',
            'manage_template',
            'manage_pattern',
            'manage_model',
            'manage_view',
            'manage_controller',
            'manage_router',
            'manage_middleware',
            'manage_filter',
            'manage_validator',
            'manage_transformer',
            'manage_serializer',
            'manage_deserializer',
            'manage_encoder',
            'manage_decoder',
            'manage_parser',
            'manage_formatter',
            'manage_converter',
            'manage_adapter',
            'manage_bridge',
            'manage_proxy',
            'manage_facade',
            'manage_decorator',
            'manage_observer',
            'manage_listener',
            'manage_subscriber',
            'manage_publisher',
            'manage_producer',
            'manage_consumer',
            'manage_worker',
            'manage_job',
            'manage_queue',
            'manage_stack',
            'manage_heap',
            'manage_tree',
            'manage_graph',
            'manage_network',
            'manage_mesh',
            'manage_grid',
            'manage_matrix',
            'manage_vector',
            'manage_array',
            'manage_list',
            'manage_set',
            'manage_map',
            'manage_dictionary',
            'manage_hash',
            'manage_cache',
            'manage_buffer',
            'manage_stream',
            'manage_pipe',
            'manage_channel',
            'manage_bus',
            'manage_event',
            'manage_signal',
            'manage_hook',
            'manage_trigger',
            'manage_action',
            'manage_reaction',
            'manage_response',
            'manage_request',
            'manage_query',
            'manage_command',
            'manage_instruction',
            'manage_directive',
            'manage_rule',
            'manage_policy',
            'manage_strategy',
            'manage_algorithm',
            'manage_formula',
            'manage_equation',
            'manage_expression',
            'manage_statement',
            'manage_declaration',
            'manage_definition',
            'manage_specification',
            'manage_requirement',
            'manage_constraint',
            'manage_condition',
            'manage_criteria',
            'manage_standard',
            'manage_benchmark',
            'manage_baseline',
            'manage_reference',
            'manage_example',
            'manage_sample',
            'manage_template',
            'manage_pattern',
            'manage_model',
            'manage_prototype',
            'manage_instance',
            'manage_object',
            'manage_entity',
            'manage_record',
            'manage_document',
            'manage_file',
            'manage_resource',
            'manage_asset',
            'manage_property',
            'manage_attribute',
            'manage_feature',
            'manage_characteristic',
            'manage_quality',
            'manage_quantity',
            'manage_amount',
            'manage_number',
            'manage_count',
            'manage_sum',
            'manage_total',
            'manage_aggregate',
            'manage_collection',
            'manage_group',
            'manage_category',
            'manage_class',
            'manage_type',
            'manage_kind',
            'manage_sort',
            'manage_order',
            'manage_sequence',
            'manage_series',
            'manage_progression',
            'manage_iteration',
            'manage_loop',
            'manage_cycle',
            'manage_period',
            'manage_phase',
            'manage_stage',
            'manage_level',
            'manage_tier',
            'manage_layer',
            'manage_stack',
            'manage_hierarchy',
            'manage_tree',
            'manage_branch',
            'manage_leaf',
            'manage_node',
            'manage_vertex',
            'manage_edge',
            'manage_connection',
            'manage_link',
            'manage_relationship',
            'manage_association',
            'manage_correlation',
            'manage_dependency',
            'manage_requirement',
            'manage_prerequisite',
            'manage_condition',
            'manage_constraint',
            'manage_limitation',
            'manage_restriction',
            'manage_boundary',
            'manage_scope',
            'manage_context',
            'manage_environment',
            'manage_setting',
            'manage_configuration',
            'manage_preference',
            'manage_option',
            'manage_choice',
            'manage_selection',
            'manage_decision',
            'manage_judgment',
            'manage_assessment',
            'manage_evaluation',
            'manage_analysis',
            'manage_review',
            'manage_audit',
            'manage_inspection',
            'manage_examination',
            'manage_investigation',
            'manage_research',
            'manage_study',
            'manage_survey',
            'manage_poll',
            'manage_vote',
            'manage_election',
            'manage_selection',
            'manage_appointment',
            'manage_assignment',
            'manage_allocation',
            'manage_distribution',
            'manage_delivery',
            'manage_shipment',
            'manage_transport',
            'manage_transfer',
            'manage_movement',
            'manage_migration',
            'manage_transition',
            'manage_change',
            'manage_modification',
            'manage_alteration',
            'manage_adjustment',
            'manage_correction',
            'manage_fix',
            'manage_repair',
            'manage_maintenance',
            'manage_service',
            'manage_support',
            'manage_help',
            'manage_assistance',
            'manage_aid',
            'manage_relief',
            'manage_rescue',
            'manage_recovery',
            'manage_restoration',
            'manage_rehabilitation',
            'manage_renewal',
            'manage_regeneration',
            'manage_rebirth',
            'manage_revival',
            'manage_resurrection',
            'manage_reincarnation',
            'manage_transformation',
            'manage_metamorphosis',
            'manage_evolution',
            'manage_development',
            'manage_growth',
            'manage_expansion',
            'manage_enlargement',
            'manage_increase',
            'manage_increment',
            'manage_addition',
            'manage_extension',
            'manage_continuation',
            'manage_prolongation',
            'manage_perpetuation',
            'manage_preservation',
            'manage_conservation',
            'manage_protection',
            'manage_security',
            'manage_safety',
            'manage_defense',
            'manage_shield',
            'manage_armor',
            'manage_guard',
            'manage_watch',
            'manage_monitor',
            'manage_observe',
            'manage_track',
            'manage_trace',
            'manage_follow',
            'manage_pursue',
            'manage_chase',
            'manage_hunt',
            'manage_search',
            'manage_find',
            'manage_discover',
            'manage_explore',
            'manage_investigate',
            'manage_examine',
            'manage_inspect',
            'manage_analyze',
            'manage_study',
            'manage_research',
            'manage_develop',
            'manage_create',
            'manage_build',
            'manage_construct',
            'manage_make',
            'manage_produce',
            'manage_generate',
            'manage_form',
            'manage_shape',
            'manage_mold',
            'manage_design',
            'manage_plan',
            'manage_project',
            'manage_forecast',
            'manage_predict',
            'manage_estimate',
            'manage_calculate',
            'manage_compute',
            'manage_process',
            'manage_handle',
            'manage_manage',
            'manage_control',
            'manage_direct',
            'manage_guide',
            'manage_lead',
            'manage_conduct',
            'manage_run',
            'manage_operate',
            'manage_execute',
            'manage_perform',
            'manage_do',
            'manage_act',
            'manage_function',
            'manage_work',
            'manage_serve',
            'manage_provide',
            'manage_supply',
            'manage_deliver',
            'manage_distribute',
            'manage_allocate',
            'manage_assign',
            'manage_appoint',
            'manage_elect',
            'manage_select',
            'manage_choose',
            'manage_pick',
            'manage_decide',
            'manage_determine',
            'manage_resolve',
            'manage_settle',
            'manage_conclude',
            'manage_finish',
            'manage_complete',
            'manage_end',
            'manage_terminate',
            'manage_stop',
            'manage_halt',
            'manage_pause',
            'manage_suspend',
            'manage_interrupt',
            'manage_break',
            'manage_discontinue',
            'manage_cease',
            'manage_quit',
            'manage_leave',
            'manage_depart',
            'manage_exit',
            'manage_escape',
            'manage_flee',
            'manage_run',
            'manage_move',
            'manage_travel',
            'manage_journey',
            'manage_trip',
            'manage_tour',
            'manage_visit',
            'manage_attend',
            'manage_participate',
            'manage_join',
            'manage_enter',
            'manage_access',
            'manage_reach',
            'manage_arrive',
            'manage_come',
            'manage_go',
            'manage_pass',
            'manage_cross',
            'manage_traverse',
            'manage_navigate',
            'manage_steer',
            'manage_direct',
            'manage_guide',
            'manage_lead',
            'manage_conduct',
            'manage_escort',
            'manage_accompany',
            'manage_follow',
            'manage_track',
            'manage_trace',
            'manage_trail',
            'manage_path',
            'manage_route',
            'manage_way',
            'manage_road',
            'manage_street',
            'manage_avenue',
            'manage_boulevard',
            'manage_lane',
            'manage_alley',
            'manage_path',
            'manage_trail',
            'manage_track',
            'manage_course',
            'manage_direction',
            'manage_orientation',
            'manage_position',
            'manage_location',
            'manage_place',
            'manage_spot',
            'manage_site',
            'manage_venue',
            'manage_area',
            'manage_region',
            'manage_zone',
            'manage_sector',
            'manage_district',
            'manage_neighborhood',
            'manage_community',
            'manage_society',
            'manage_population',
            'manage_people',
            'manage_person',
            'manage_individual',
            'manage_citizen',
            'manage_resident',
            'manage_inhabitant',
            'manage_dweller',
            'manage_occupant',
            'manage_tenant',
            'manage_renter',
            'manage_lessee',
            'manage_owner',
            'manage_proprietor',
            'manage_possessor',
            'manage_holder',
            'manage_keeper',
            'manage_custodian',
            'manage_guardian',
            'manage_protector',
            'manage_defender',
            'manage_advocate',
            'manage_supporter',
            'manage_backer',
            'manage_sponsor',
            'manage_patron',
            'manage_benefactor',
            'manage_donor',
            'manage_contributor',
            'manage_provider',
            'manage_supplier',
            'manage_vendor',
            'manage_seller',
            'manage_merchant',
            'manage_trader',
            'manage_dealer',
            'manage_retailer',
            'manage_wholesaler',
            'manage_distributor',
            'manage_agent',
            'manage_representative',
            'manage_delegate',
            'manage_ambassador',
            'manage_emissary',
            'manage_envoy',
            'manage_messenger',
            'manage_courier',
            'manage_carrier',
            'manage_transporter',
            'manage_shipper',
            'manage_sender',
            'manage_receiver',
            'manage_recipient',
            'manage_addressee',
            'manage_target',
            'manage_destination',
            'manage_end',
            'manage_goal',
            'manage_objective',
            'manage_aim',
            'manage_purpose',
            'manage_intention',
            'manage_intent',
            'manage_motive',
            'manage_reason',
            'manage_cause',
            'manage_source',
            'manage_origin',
            'manage_root',
            'manage_base',
            'manage_foundation',
            'manage_ground',
            'manage_basis',
            'manage_core',
            'manage_heart',
            'manage_center',
            'manage_middle',
            'manage_midst',
            'manage_interior',
            'manage_inside',
            'manage_internal',
            'manage_inner',
            'manage_central',
            'manage_main',
            'manage_primary',
            'manage_principal',
            'manage_chief',
            'manage_key',
            'manage_major',
            'manage_important',
            'manage_significant',
            'manage_essential',
            'manage_vital',
            'manage_critical',
            'manage_crucial',
            'manage_decisive',
            'manage_determining',
            'manage_definitive',
            'manage_final',
            'manage_ultimate',
            'manage_supreme',
            'manage_paramount',
            'manage_foremost',
            'manage_leading',
            'manage_top',
            'manage_premium',
            'manage_elite',
            'manage_select',
            'manage_choice',
            'manage_prime',
            'manage_first',
            'manage_best',
            'manage_finest',
            'manage_superior',
            'manage_excellent',
            'manage_outstanding',
            'manage_exceptional',
            'manage_extraordinary',
            'manage_remarkable',
            'manage_notable',
            'manage_noteworthy',
            'manage_significant',
            'manage_important',
            'manage_major',
            'manage_main',
            'manage_primary',
            'manage_principal',
            'manage_chief',
            'manage_key',
            'manage_central',
            'manage_core',
            'manage_essential',
            'manage_vital',
            'manage_critical',
            'manage_crucial',
            'manage_decisive',
            'manage_determining',
            'manage_definitive',
            'manage_final',
            'manage_ultimate',
            'manage_supreme',
            'manage_paramount',
            'manage_foremost',
            'manage_leading',
            'manage_top',
            'manage_premium',
            'manage_elite',
            'manage_select',
            'manage_choice',
            'manage_prime',
            'manage_first',
            'manage_best',
            'manage_finest',
            'manage_superior',
            'manage_excellent',
            'manage_outstanding',
            'manage_exceptional',
            'manage_extraordinary',
            'manage_remarkable',
            'manage_notable',
            'manage_noteworthy',
            'manage_significant',
            'manage_important',
            'manage_major',
            'manage_main',
            'manage_primary',
            'manage_principal',
            'manage_chief',
            'manage_key',
            'manage_central',
            'manage_core',
            'manage_essential',
            'manage_vital',
            'manage_critical',
            'manage_crucial',
            'manage_decisive',
            'manage_determining',
            'manage_definitive',
            'manage_final',
            'manage_ultimate',
            'manage_supreme',
            'manage_paramount',
            'manage_foremost',
            'manage_leading',
            'manage_top',
            'manage_premium',
            'manage_elite',
            'manage_select',
            'manage_choice',
            'manage_prime',
            'manage_first',
            'manage_best',
            'manage_finest',
            'manage_superior',
            'manage_excellent',
            'manage_outstanding',
            'manage_exceptional',
            'manage_extraordinary',
            'manage_remarkable',
            'manage_notable',
            'manage_noteworthy'
        ];

        // إضافة صلاحيات خاصة بالقائمة الجانبية
        foreach ($sidebarPermissions as $permName) {
            // التحقق من وجود الصلاحية أولاً
            $permission = Permission::where('name', $permName)->first();

            // إذا لم تكن موجودة، نستخدم الصلاحيات الموجودة بالفعل
            if (!$permission) {
                continue;
            }

            DB::table('user_permission')->updateOrInsert(
                ['user_id' => $user->id, 'permission_id' => $permission->id],
                [
                    'granted' => true,
                    'source' => 'direct',
                    'created_at' => now(),
                    'updated_at' => now()
                ]
            );
        }

        // تعديل ملف القالب لإظهار جميع عناصر القائمة الجانبية
        $this->info("تم إعطاء المستخدم {$email} جميع الصلاحيات الخاصة بالقائمة الجانبية");

        return Command::SUCCESS;
    }
}
