<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\JournalEntry;
use App\Models\CashTransaction;
use Illuminate\Support\Facades\DB;

class FixCashTransactionEntries extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:cash-transaction-entries';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إصلاح العلاقة بين معاملات الخزينة والقيود المحاسبية';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء إصلاح العلاقة بين معاملات الخزينة والقيود المحاسبية...');

        // البحث عن القيود المحاسبية المرتبطة بمعاملات الخزينة
        $journalEntries = JournalEntry::where('reference_type', 'App\\Models\\CashTransaction')
            ->whereNotNull('reference_id')
            ->get();

        $count = 0;

        foreach ($journalEntries as $entry) {
            // التحقق من وجود معاملة الخزينة
            $cashTransaction = CashTransaction::find($entry->reference_id);

            if ($cashTransaction) {
                // التحقق من وجود سجل في جدول الربط
                $exists = DB::table('cash_transaction_entries')
                    ->where('cash_transaction_id', $cashTransaction->id)
                    ->where('journal_entry_id', $entry->id)
                    ->exists();

                if (!$exists) {
                    // إنشاء سجل في جدول الربط
                    DB::table('cash_transaction_entries')->insert([
                        'cash_transaction_id' => $cashTransaction->id,
                        'journal_entry_id' => $entry->id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);

                    $count++;
                    $this->info("تم إصلاح العلاقة للقيد المحاسبي رقم {$entry->entry_number} ومعاملة الخزينة رقم {$cashTransaction->id}");
                }
            }
        }

        $this->info("تم الانتهاء من الإصلاح. تم إصلاح {$count} علاقة.");

        return 0;
    }
}
