<?php

namespace App\Console\Commands;

use App\Models\Bank;
use App\Services\BankAccountService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class FixBankAccounts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'banks:fix-accounts';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إنشاء حسابات في شجرة الحسابات للبنوك التي ليس لها حسابات';

    /**
     * @var BankAccountService
     */
    protected $bankAccountService;

    /**
     * Create a new command instance.
     *
     * @param BankAccountService $bankAccountService
     * @return void
     */
    public function __construct(BankAccountService $bankAccountService)
    {
        parent::__construct();
        $this->bankAccountService = $bankAccountService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء إصلاح حسابات البنوك في شجرة الحسابات...');

        // الحصول على جميع البنوك
        $banks = Bank::all();
        $count = 0;

        foreach ($banks as $bank) {
            // البحث عن حساب البنك في شجرة الحسابات
            $account = $this->bankAccountService->findBankAccount($bank);

            if (!$account) {
                // إنشاء حساب للبنك إذا لم يكن موجوداً
                $account = $this->bankAccountService->createBankAccount($bank);

                if ($account) {
                    $count++;
                    $this->info("تم إنشاء حساب للبنك: {$bank->name} (ID: {$bank->id})");
                } else {
                    $this->error("فشل في إنشاء حساب للبنك: {$bank->name} (ID: {$bank->id})");
                }
            } else {
                $this->line("البنك {$bank->name} (ID: {$bank->id}) لديه حساب بالفعل في شجرة الحسابات (ID: {$account->id})");
            }
        }

        $this->info("تم الانتهاء من إصلاح حسابات البنوك. تم إنشاء {$count} حساب جديد.");

        Log::info("تم تنفيذ أمر إصلاح حسابات البنوك. تم إنشاء {$count} حساب جديد.");

        return 0;
    }
}
